<?php

namespace Hepta\Plugin\Contact\HeptaContactPot\Extension;

use Joomla\Event\SubscriberInterface;
use Joomla\CMS\Plugin\CMSPlugin;
use Joomla\CMS\Language\Text;
use Joomla\Utilities\ArrayHelper;

\defined('_JEXEC') or die;

class HeptaContactPot extends CMSPlugin implements SubscriberInterface
{
    protected $autoloadLanguage = true;

    public static function getSubscribedEvents(): array
    {
        return [
            'onValidateContact' => 'validateContact'
        ];
    }


    /**
     * Add additional fields to the supported forms
     *
     * @param   Form   $form  The form to be altered.
     * @param   mixed  $data  The associated data for the form.
     *
     * @return  boolean
     */
    public function validateContact($event)
    {
        $result = null;
        $contact = $event->getContact();
        $data = $event->getData();

        if ($this->params->get('filter_cyrillic', 1) && $this->inCyrillic($data['contact_message'])) {
            $reason = 'Message contains Cyrillic characters';
            $result =  $this->spamDetected($data, $reason);
        }

        $forbiddenWords = $this->params->get('forbidden_words', []);

        $forbiddenWords = array_filter(ArrayHelper::flatten(ArrayHelper::fromObject($forbiddenWords, true)));

        foreach ($forbiddenWords as $word) {
            $word = trim($word);

            if (empty($word)) {
                continue;
            }

            if (preg_match("/\b$word\b/i", $data['contact_message'], $matches)) {
                $reason = 'Matching ' . implode(', ', $matches);
                $result = $this->spamDetected($data, $reason);
            }
        }

        if (isset($data['phone_hepta']) && !empty($data['phone_hepta'])) {
            $reason = 'Filled honeypot field';
            $result = $this->spamDetected($data, $reason);
        }



        $event->addResult($result);
    }

    /**
     * If SPAM is detected we throw an exception
     * @param String    $message
     */
    public function spamDetected($data, string $reason)
    {
        $this->getApplication()->enqueueMessage(Text::_('PLG_HEPTACONTACT_MSG_MESSAGE_SENT'), 'success');

        return new \Exception($reason);
    }

    /**
     * Detects if it has Cyrillic characters
     */
    protected function inCyrillic($text)
    {
        return preg_match('/[А-Яа-яЁё]/u', $text);
    }
}
